package abstraction;
/**
 * @author Chiara Coccia, Diego Colarullo
 * @version 1.5 09/03/18
 * @since JDK 1.6
 */


/** 
 * This Class maintains informations about the triple present state, action, next state of one Service.
 */
public class TransitionFunction {

	private State presentState;
	private Action action;
	private State nextState;

	/**
	 * Constructor 
	 * @param presentState
	 * @param action
	 * @param nextState
	 */
	public TransitionFunction(State presentState, Action action, State nextState){
		this.presentState = presentState;
		this.action = action;
		this.nextState = nextState;		
	}
		
	/**
	 * get a present state of a transition function
	 * @return present state of transaction function
	 */
	public State getPresentState(){
		return this.presentState;
	}

	/**
	 * get action of a transition function
	 * @return action of transaction function
	 */
	public Action getAction(){
		return this.action;
	}
	/**
	 * get a next state  of a transition function
	 * @return next state of transaction function
	 */
	public State getNextState(){
		return this.nextState;
	}
	
	// override of equals method to compare transitionFunction not in superficial way 
	public boolean equals(Object o) {
    	if (o != null && getClass().equals(o.getClass())) {
    		TransitionFunction other = (TransitionFunction)o;
    		return this.presentState.equals(other.presentState) &&  this.action.equals(other.action) && this.nextState.equals(other.nextState);
    	}
    	else 
    		return false;
    }    
	
	/**
	 * @return int that represent the sum of hashCode of presentState, nextState and action 
	 */
	public int hashCode(){ 
        return (this.presentState+""+this.nextState+""+this.action).hashCode(); 
    }
		
	// override of toString method to print a TransitionFunction 
	public String toString() {
		return "\n(presentState=" + presentState+ ", action=" + action+ ", nextState=" + nextState+")";
	}
}
